/*
 * Decompiled with CFR 0.152.
 */
package fuzs.diagonalfences.core;

import fuzs.diagonalfences.world.phys.shapes.VoxelUtils;
import java.util.stream.Stream;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;

public enum EightWayDirection {
    SOUTH(0, new class_2382(0, 0, 1)),
    WEST(1, new class_2382(-1, 0, 0)),
    NORTH(2, new class_2382(0, 0, -1)),
    EAST(3, new class_2382(1, 0, 0)),
    SOUTH_WEST(0, new class_2382(-1, 0, 1)),
    NORTH_WEST(1, new class_2382(-1, 0, -1)),
    NORTH_EAST(2, new class_2382(1, 0, -1)),
    SOUTH_EAST(3, new class_2382(1, 0, 1));

    public static final EightWayDirection[] CARDINAL_DIRECTIONS;
    public static final EightWayDirection[] INTERCARDINAL_DIRECTIONS;
    private final int data2d;
    private final class_2382 directionVec;

    private EightWayDirection(int data2d, class_2382 directionVec) {
        this.data2d = data2d;
        this.directionVec = directionVec;
    }

    public class_2382 directionVec() {
        return this.directionVec;
    }

    public boolean cardinal() {
        return !this.intercardinal();
    }

    public boolean intercardinal() {
        return this.directionVec.method_10263() != 0 && this.directionVec.method_10260() != 0;
    }

    public int getHorizontalIndex() {
        return 1 << (this.intercardinal() ? 4 + this.data2d : this.data2d);
    }

    public class_243[] transform(class_243[] vectors) {
        if (this.directionVec.method_10263() != 0) {
            vectors = VoxelUtils.ortho(vectors);
        }
        if (this.directionVec.method_10263() == -1 || this.directionVec.method_10260() == -1) {
            vectors = VoxelUtils.mirror(vectors);
        }
        return vectors;
    }

    public EightWayDirection opposite() {
        return EightWayDirection.byIndex(this.data2d + 2, this.intercardinal());
    }

    public EightWayDirection[] getCardinalNeighbors() {
        if (!this.intercardinal()) {
            throw new IllegalStateException("Direction already is cardinal");
        }
        return new EightWayDirection[]{EightWayDirection.byIndex(this.data2d, false), EightWayDirection.byIndex(this.data2d + 1, false)};
    }

    public EightWayDirection[] getIntercardinalNeighbors() {
        if (!this.cardinal()) {
            throw new IllegalStateException("Direction already is intercardinal");
        }
        return new EightWayDirection[]{EightWayDirection.byIndex(this.data2d + 3, true), EightWayDirection.byIndex(this.data2d, true)};
    }

    public class_2350 toDirection() {
        if (!this.cardinal()) {
            throw new IllegalStateException("Cannot convert intercardinal direction to vanilla direction");
        }
        return class_2350.method_10139((int)this.data2d);
    }

    public static EightWayDirection toEightWayDirection(class_2350 direction) {
        return CARDINAL_DIRECTIONS[direction.method_10161()];
    }

    public static EightWayDirection byIndex(int index, boolean intercardinal) {
        return intercardinal ? INTERCARDINAL_DIRECTIONS[index % 4] : CARDINAL_DIRECTIONS[index % 4];
    }

    static {
        CARDINAL_DIRECTIONS = (EightWayDirection[])Stream.of(EightWayDirection.values()).filter(EightWayDirection::cardinal).toArray(EightWayDirection[]::new);
        INTERCARDINAL_DIRECTIONS = (EightWayDirection[])Stream.of(EightWayDirection.values()).filter(EightWayDirection::intercardinal).toArray(EightWayDirection[]::new);
    }
}

